<?php
session_start();
require_once __DIR__ . '/db.php';

function login($username, $password) {
  global $pdo;
  $stmt = $pdo->prepare('SELECT * FROM users WHERE username = ?');
  $stmt->execute([$username]);
  $user = $stmt->fetch();
  if ($user && password_verify($password, $user['password'])) {
    $_SESSION['user'] = ['id'=>$user['id'],'username'=>$user['username'],'role'=>$user['role']];
    return true;
  }
  return false;
}

function require_role($roles = []) {
  if (!isset($_SESSION['user']) || !in_array($_SESSION['user']['role'], (array)$roles)) {
    header('Location: /login.php'); exit;
  }
}

function current_user() {
  return $_SESSION['user'] ?? null;
}
